/*
 * Decompiled with CFR 0.152.
 */
package loan;

import com.nokia.mid.appl.calc2.Local;
import common.control.Calculator2;
import common.control.ConfigurationManager;
import common.control.DisplayManager;
import common.control.SettingsManager;
import common.misc.GlobalParameters;
import common.ui.InstructionsForm;
import common.util.Calculator;
import common.util.Tools;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public final class LoanForm
extends Form
implements CommandListener,
ItemCommandListener,
ItemStateListener {
    private static final Command COMMAND_CALCULATE = new Command(Local.getText(16), 4, 0);
    private static final Command COMMAND_EMPTY = new Command("\u00a0", 1, 0);
    private static final Command COMMAND_STANDARD_CALCULATOR = new Command(Local.getText(22), 1, 1);
    private static final Command COMMAND_SCIENTIFIC_CALCULATOR = new Command(Local.getText(15), 1, 2);
    private static final int LOAN_AMOUNT_DIGITS = 10;
    private static final int ANNUAL_INTEREST_RATE_DIGITS = 7;
    private static final int LOAN_TIME_DIGITS = 5;
    private static final int MONTHLY_FEE_DIGITS = 10;
    private static final double ANNUAL_INTEREST_RATE_MAXIMUM_VALUE = 100.0;
    private static final double LOAN_TIME_MINIMUM_VALUE = 1.0;
    private final Calculator2 midlet;
    private Alert alert;
    private final TextField[] textFields;
    private boolean inlineEditingSupported = ConfigurationManager.getInstance().isInlineEditingSupported();

    public LoanForm(Calculator2 midlet) {
        super(Local.getText(30));
        this.midlet = midlet;
        this.textFields = new TextField[4];
        this.appendTextFields();
        this.addCommands();
        this.setCommandListener(this);
        this.setItemStateListener(this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == GlobalParameters.COMMAND_EXIT) {
            this.showConfirmation("Confirmation", "Really exit?");
        } else if (c == COMMAND_STANDARD_CALCULATOR) {
            DisplayManager.getInstance().pop();
            DisplayManager.getInstance().push((Displayable)this.midlet.getStandardCalculator());
            SettingsManager.getInstance().setDefaultCalculatorMode(0);
        } else if (c == COMMAND_SCIENTIFIC_CALCULATOR) {
            DisplayManager.getInstance().pop();
            DisplayManager.getInstance().push((Displayable)this.midlet.getScientificCalculator());
            SettingsManager.getInstance().setDefaultCalculatorMode(1);
        } else if (c == GlobalParameters.COMMAND_INSTRUCTIONS) {
            DisplayManager.getInstance().push((Displayable)new InstructionsForm(this.midlet, false, Local.getText(1)));
        }
    }

    public void commandAction(Command command, Item item) {
        block29: {
            if (command != COMMAND_CALCULATE) {
                return;
            }
            String result = null;
            String outOfRange = null;
            Alert alert = null;
            if (item == this.textFields[0]) {
                this.textFields[0].setString("");
                try {
                    this.setAnnualInterestRateToMaximumValue();
                    this.setLoanTimeToMinimumValue();
                    double annualInterestRate = Tools.getInstance().parseDouble(this.textFields[1].getString()) / 100.0;
                    double loanTime = Tools.getInstance().parseDouble(this.textFields[2].getString());
                    double monthlyFee = Tools.getInstance().parseDouble(this.textFields[3].getString());
                    if (annualInterestRate == 0.0 || loanTime == 0.0 || monthlyFee == 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(14), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    if (annualInterestRate < 0.0 || loanTime < 0.0 || monthlyFee < 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(8), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    double loanAmount = this.calculateLoanAmount(annualInterestRate, loanTime, monthlyFee);
                    result = Tools.getInstance().doubleToStringRounded(Tools.getInstance().roundDouble(loanAmount, 2), 10);
                    if (result != null) {
                        this.textFields[0].setString(result);
                        this.itemStateChanged((Item)this.textFields[0]);
                        break block29;
                    }
                    outOfRange = Local.getText(11, new String[]{String.valueOf(10)});
                    alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
                catch (ArithmeticException e) {
                    alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
            } else if (item == this.textFields[1]) {
                this.textFields[1].setString("");
                try {
                    this.setLoanTimeToMinimumValue();
                    double loanAmount = Tools.getInstance().parseDouble(this.textFields[0].getString());
                    double loanTime = Tools.getInstance().parseDouble(this.textFields[2].getString());
                    double monthlyFee = Tools.getInstance().parseDouble(this.textFields[3].getString());
                    if (loanAmount == 0.0 || loanTime == 0.0 || monthlyFee == 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(14), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    if (loanAmount < 0.0 || loanTime < 0.0 || monthlyFee < 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(8), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    double annualInterestRate = this.calculateAnnualInterestRate(loanAmount, loanTime, monthlyFee);
                    result = annualInterestRate >= 0.01 ? Tools.getInstance().doubleToStringRounded(Tools.getInstance().roundDouble(annualInterestRate, 2), 7) : Tools.getInstance().doubleToStringRounded(Tools.getInstance().roundDouble(annualInterestRate, 3), 7);
                    if (result != null) {
                        this.textFields[1].setString(result);
                        this.itemStateChanged((Item)this.textFields[1]);
                        break block29;
                    }
                    outOfRange = Local.getText(11, new String[]{String.valueOf(7)});
                    alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
                catch (ArithmeticException e) {
                    alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
            } else if (item == this.textFields[2]) {
                this.textFields[2].setString("");
                try {
                    this.setAnnualInterestRateToMaximumValue();
                    double loanAmount = Tools.getInstance().parseDouble(this.textFields[0].getString());
                    double annualInterestRate = Tools.getInstance().parseDouble(this.textFields[1].getString()) / 100.0;
                    double monthlyFee = Tools.getInstance().parseDouble(this.textFields[3].getString());
                    if (loanAmount == 0.0 || annualInterestRate == 0.0 || monthlyFee == 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(14), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    if (loanAmount < 0.0 || annualInterestRate < 0.0 || monthlyFee < 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(8), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    double loanTime = this.calculateLoanTime(loanAmount, annualInterestRate, monthlyFee);
                    result = Tools.getInstance().doubleToStringRounded(Tools.getInstance().roundDouble(loanTime, 2), 5);
                    if (result != null) {
                        this.textFields[2].setString(result);
                        this.itemStateChanged((Item)this.textFields[2]);
                        break block29;
                    }
                    outOfRange = Local.getText(11, new String[]{String.valueOf(5)});
                    alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
                catch (ArithmeticException e) {
                    alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
            } else if (item == this.textFields[3]) {
                this.textFields[3].setString("");
                try {
                    this.setAnnualInterestRateToMaximumValue();
                    this.setLoanTimeToMinimumValue();
                    double loanAmount = Tools.getInstance().parseDouble(this.textFields[0].getString());
                    double annualInterestRate = Tools.getInstance().parseDouble(this.textFields[1].getString()) / 100.0;
                    double loanTime = Tools.getInstance().parseDouble(this.textFields[2].getString());
                    if (loanAmount == 0.0 || annualInterestRate == 0.0 || loanTime == 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(14), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    if (loanAmount < 0.0 || annualInterestRate < 0.0 || loanTime < 0.0) {
                        alert = new Alert(Local.getText(28), Local.getText(8), null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                        return;
                    }
                    double monthlyFee = this.calculateMonthlyFee(loanAmount, annualInterestRate, loanTime);
                    result = Tools.getInstance().doubleToStringRounded(Tools.getInstance().roundDouble(monthlyFee, 2), 10);
                    if (result != null) {
                        this.textFields[3].setString(result);
                        this.itemStateChanged((Item)this.textFields[3]);
                    } else {
                        outOfRange = Local.getText(11, new String[]{String.valueOf(10)});
                        alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
                        DisplayManager.getInstance().push(alert);
                    }
                }
                catch (ArithmeticException e) {
                    alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
                    DisplayManager.getInstance().push(alert);
                }
            }
        }
    }

    public void itemStateChanged(Item item) {
        if (item instanceof TextField) {
            if (this.textFields[1].getString().length() > 0 && this.textFields[2].getString().length() > 0 && this.textFields[3].getString().length() > 0) {
                this.textFields[0].setDefaultCommand(COMMAND_CALCULATE);
                if (this.inlineEditingSupported) {
                    this.textFields[0].removeCommand(COMMAND_EMPTY);
                }
            } else if (this.textFields[1].getString().length() == 0 || this.textFields[2].getString().length() == 0 || this.textFields[3].getString().length() == 0) {
                if (this.inlineEditingSupported) {
                    this.textFields[0].setDefaultCommand(COMMAND_EMPTY);
                }
                this.textFields[0].removeCommand(COMMAND_CALCULATE);
            }
            if (this.textFields[0].getString().length() > 0 && this.textFields[2].getString().length() > 0 && this.textFields[3].getString().length() > 0) {
                this.textFields[1].setDefaultCommand(COMMAND_CALCULATE);
                if (this.inlineEditingSupported) {
                    this.textFields[1].removeCommand(COMMAND_EMPTY);
                }
            } else if (this.textFields[0].getString().length() == 0 || this.textFields[2].getString().length() == 0 || this.textFields[3].getString().length() == 0) {
                if (this.inlineEditingSupported) {
                    this.textFields[1].setDefaultCommand(COMMAND_EMPTY);
                }
                this.textFields[1].removeCommand(COMMAND_CALCULATE);
            }
            if (this.textFields[0].getString().length() > 0 && this.textFields[1].getString().length() > 0 && this.textFields[3].getString().length() > 0) {
                this.textFields[2].setDefaultCommand(COMMAND_CALCULATE);
                if (this.inlineEditingSupported) {
                    this.textFields[2].removeCommand(COMMAND_EMPTY);
                }
            } else if (this.textFields[0].getString().length() == 0 || this.textFields[1].getString().length() == 0 || this.textFields[3].getString().length() == 0) {
                if (this.inlineEditingSupported) {
                    this.textFields[2].setDefaultCommand(COMMAND_EMPTY);
                }
                this.textFields[2].removeCommand(COMMAND_CALCULATE);
            }
            if (this.textFields[0].getString().length() > 0 && this.textFields[1].getString().length() > 0 && this.textFields[2].getString().length() > 0) {
                this.textFields[3].setDefaultCommand(COMMAND_CALCULATE);
                if (this.inlineEditingSupported) {
                    this.textFields[3].removeCommand(COMMAND_EMPTY);
                }
            } else if (this.textFields[0].getString().length() == 0 || this.textFields[1].getString().length() == 0 || this.textFields[2].getString().length() == 0) {
                if (this.inlineEditingSupported) {
                    this.textFields[3].setDefaultCommand(COMMAND_EMPTY);
                }
                this.textFields[3].removeCommand(COMMAND_CALCULATE);
            }
            Tools.getInstance().triggerGarbageCollection();
        }
    }

    private void addCommands() {
        this.addCommand(GlobalParameters.COMMAND_EXIT);
        this.addCommand(COMMAND_STANDARD_CALCULATOR);
        this.addCommand(COMMAND_SCIENTIFIC_CALCULATOR);
        this.addCommand(GlobalParameters.COMMAND_INSTRUCTIONS);
        if (this.inlineEditingSupported) {
            for (int i = 0; i < this.textFields.length; ++i) {
                this.textFields[i].setDefaultCommand(COMMAND_EMPTY);
            }
        }
    }

    private void appendTextFields() {
        String label = null;
        label = Local.getText(24);
        this.textFields[0] = new TextField(label, null, 10, 5);
        this.textFields[0].setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.textFields[0]);
        label = Local.getText(23);
        this.textFields[1] = new TextField(label, null, 7, 5);
        this.textFields[1].setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.textFields[1]);
        label = Local.getText(25);
        this.textFields[2] = new TextField(label, null, 5, 5);
        this.textFields[2].setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.textFields[2]);
        label = Local.getText(26);
        this.textFields[3] = new TextField(label, null, 10, 5);
        this.textFields[3].setItemCommandListener((ItemCommandListener)this);
        this.append((Item)this.textFields[3]);
    }

    private double calculateLoanAmount(double annualInterestRate, double loanTime, double monthlyFee) throws ArithmeticException {
        double monthlyInterestRate = annualInterestRate / 12.0;
        double temp = Calculator.getInstance().pow(1.0 + monthlyInterestRate, loanTime);
        if (temp == 0.0 || annualInterestRate == 0.0) {
            throw new ArithmeticException(Local.getText(4));
        }
        return monthlyFee * (temp - 1.0) / (monthlyInterestRate * temp);
    }

    private double calculateAnnualInterestRate(double loanAmount, double loanTime, double monthlyFee) throws ArithmeticException {
        double annualInterestRate = 50.0;
        double delta = annualInterestRate / 2.0;
        for (int i = 0; i < 20; ++i) {
            double calculatedLoanAmount = this.calculateLoanAmount(annualInterestRate / 100.0, loanTime, monthlyFee);
            if (calculatedLoanAmount > loanAmount) {
                annualInterestRate += delta;
            } else if (calculatedLoanAmount < loanAmount) {
                annualInterestRate -= delta;
            } else if (calculatedLoanAmount == loanAmount) break;
            delta /= 2.0;
        }
        return annualInterestRate;
    }

    private double calculateLoanTime(double loanAmount, double annualInterestRate, double monthlyFee) throws ArithmeticException {
        double monthlyInterestRate = annualInterestRate / 12.0;
        double numerator = Calculator.getInstance().log(1.0 - monthlyInterestRate * loanAmount / monthlyFee);
        double denominator = Calculator.getInstance().log(1.0 + monthlyInterestRate);
        if (denominator == 0.0) {
            throw new ArithmeticException(Local.getText(4));
        }
        return -numerator / denominator;
    }

    private double calculateMonthlyFee(double loanAmount, double annualInterestRate, double loanTime) throws ArithmeticException {
        double monthlyInterestRate = annualInterestRate / 12.0;
        double temp = Calculator.getInstance().pow(1.0 + monthlyInterestRate, loanTime);
        if (temp == 1.0) {
            throw new ArithmeticException(Local.getText(4));
        }
        return loanAmount * (monthlyInterestRate * temp) / (temp - 1.0);
    }

    private void setAnnualInterestRateToMaximumValue() {
        try {
            double monthlyInterestRate = Double.parseDouble(this.textFields[1].getString());
            if (monthlyInterestRate > 100.0) {
                this.textFields[1].setString(Tools.getInstance().doubleToStringRounded(100.0, 7));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setLoanTimeToMinimumValue() {
        try {
            double loanTime = Double.parseDouble(this.textFields[2].getString());
            if (loanTime < 1.0) {
                this.textFields[2].setString(Tools.getInstance().doubleToStringRounded(1.0, 5));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void showConfirmation(String title, String text) {
        this.alert = new Alert(title, text, null, AlertType.CONFIRMATION);
        this.alert.addCommand(new Command("Yes", 4, 1));
        this.alert.addCommand(new Command("No", 3, 1));
        this.alert.setCommandListener(new CommandListener(){

            public void commandAction(Command c, Displayable d) {
                if (c.getLabel().equals("Yes")) {
                    LoanForm.this.closeAlert();
                    LoanForm.this.midlet.notifyDestroyed();
                }
                if (c.getLabel().equals("No")) {
                    LoanForm.this.closeAlert();
                }
            }
        });
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.alert, (Displayable)this);
    }

    private void closeAlert() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.alert = null;
    }
}

